@echo off

:: Ensure PowerShell is available
where PowerShell >nul 2>&1 || (
    echo PowerShell is not available. Please install or enable PowerShell.
    pause & exit 1
)
:: Ensure admin privileges
fltmc >nul 2>&1 || (
    echo Administrator privileges are required.
    PowerShell Start -Verb RunAs '%0' 2> nul || (
        echo Right-click on the script and select "Run as administrator".
        pause & exit 1
    )
    exit 0
)
:: Initialize environment
setlocal EnableExtensions DisableDelayedExpansion


:: ----------------------------------------------------------
:: -----------------Remove Xbox App (revert)-----------------
:: ----------------------------------------------------------
echo --- Remove Xbox App (revert)
:: Reinstall 'Microsoft.GamingApp' if it was previously uninstalled
PowerShell -ExecutionPolicy Unrestricted -Command "$packageName='Microsoft.GamingApp'; $publisherId='8wekyb3d8bbwe'; if (Get-AppxPackage -Name $packageName) { Write-Host "^""Skipping, `"^""$packageName`"^"" is already installed for the current user."^""; exit 0; }; Write-Host "^""Starting the installation process for `"^""$packageName`"^""..."^""; <# Attempt installation using the manifest file #>; Write-Host "^""Checking if `"^""$packageName`"^"" is installed on another user profile..."^""; $packages = @(Get-AppxPackage -AllUsers $packageName); if (!$packages) { Write-Host "^""`"^""$packageName`"^"" is not installed on any other user profiles."^""; } else { foreach ($package in $packages) { Write-Host "^""Found package `"^""$($package.PackageFullName)`"^""."^""; $installationDir = $package.InstallLocation; if ([string]::IsNullOrWhiteSpace($installationDir)) { Write-Warning "^""Installation directory for `"^""$packageName`"^"" is not found or invalid."^""; continue; }; $manifestPath = Join-Path -Path $installationDir -ChildPath 'AppxManifest.xml'; try { if (-Not (Test-Path "^""$manifestPath"^"")) { Write-Host "^""Manifest file not found for `"^""$packageName`"^"" on another user profile: `"^""$manifestPath`"^""."^""; continue; }; } catch { Write-Warning "^""An error occurred while checking for the manifest file: $($_.Exception.Message)"^""; continue; }; Write-Host "^""Manifest file located. Trying to install using the manifest: `"^""$manifestPath`"^""..."^""; try { Add-AppxPackage -DisableDevelopmentMode -Register "^""$manifestPath"^"" -ErrorAction Stop; Write-Host "^""Successfully installed `"^""$packageName`"^"" using its manifest file."^""; exit 0; } catch { Write-Warning "^""Error installing from manifest: $($_.Exception.Message)"^""; }; }; }; <# Attempt installation using the package family name #>; $packageFamilyName = "^""$($packageName)_$($publisherId)"^""; Write-Host "^""Trying to install `"^""$packageName`"^"" using its package family name: `"^""$packageFamilyName`"^"" from system installation..."^""; try { Add-AppxPackage -RegisterByFamilyName -MainPackage $packageFamilyName -ErrorAction Stop; Write-Host "^""Successfully installed `"^""$packageName`"^"" using its package family name."^""; exit 0; } catch { Write-Warning "^""Error installing using package family name: $($_.Exception.Message)"^""; }; throw "^""Unable to reinstall the requested package ($packageName). "^"" + "^""It appears to no longer be included in this version of Windows. "^"" + "^""You may search for it or an alternative in the Microsoft Store or "^"" + "^""consider using an earlier version of Windows where this package was originally provided."^"""
:: Remove 'Microsoft.GamingApp' from deprovisioned list to allow reinstall during updates.
:: Restore "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Appx\AppxAllUserStore\Deprovisioned\Microsoft.GamingApp_8wekyb3d8bbwe" registry key by deleting it
PowerShell -ExecutionPolicy Unrestricted -Command "$keyPath='HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Appx\AppxAllUserStore\Deprovisioned\Microsoft.GamingApp_8wekyb3d8bbwe'; $registryHive = $keyPath.Split('\')[0]; $registryPath = "^""$($registryHive):$($keyPath.Substring($registryHive.Length))"^""; Write-Host "^""Removing registry key at `"^""$registryPath`"^""."^""; if (-not (Test-Path -LiteralPath $registryPath)) { Write-Host "^""Skipping, no action needed, registry key `"^""$registryPath`"^"" does not exist."^""; exit 0; }; try { Remove-Item -LiteralPath $registryPath -Force -ErrorAction Stop | Out-Null; Write-Host "^""Successfully removed the registry key at path `"^""$registryPath`"^""."^""; } catch { Write-Error "^""Failed to remove the registry key at path `"^""$registryPath`"^"": $($_.Exception.Message)"^""; }"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -----------------Remove Game Bar (revert)-----------------
:: ----------------------------------------------------------
echo --- Remove Game Bar (revert)
:: Reinstall 'Microsoft.XboxGamingOverlay' if it was previously uninstalled
PowerShell -ExecutionPolicy Unrestricted -Command "$packageName='Microsoft.XboxGamingOverlay'; $publisherId='8wekyb3d8bbwe'; if (Get-AppxPackage -Name $packageName) { Write-Host "^""Skipping, `"^""$packageName`"^"" is already installed for the current user."^""; exit 0; }; Write-Host "^""Starting the installation process for `"^""$packageName`"^""..."^""; <# Attempt installation using the manifest file #>; Write-Host "^""Checking if `"^""$packageName`"^"" is installed on another user profile..."^""; $packages = @(Get-AppxPackage -AllUsers $packageName); if (!$packages) { Write-Host "^""`"^""$packageName`"^"" is not installed on any other user profiles."^""; } else { foreach ($package in $packages) { Write-Host "^""Found package `"^""$($package.PackageFullName)`"^""."^""; $installationDir = $package.InstallLocation; if ([string]::IsNullOrWhiteSpace($installationDir)) { Write-Warning "^""Installation directory for `"^""$packageName`"^"" is not found or invalid."^""; continue; }; $manifestPath = Join-Path -Path $installationDir -ChildPath 'AppxManifest.xml'; try { if (-Not (Test-Path "^""$manifestPath"^"")) { Write-Host "^""Manifest file not found for `"^""$packageName`"^"" on another user profile: `"^""$manifestPath`"^""."^""; continue; }; } catch { Write-Warning "^""An error occurred while checking for the manifest file: $($_.Exception.Message)"^""; continue; }; Write-Host "^""Manifest file located. Trying to install using the manifest: `"^""$manifestPath`"^""..."^""; try { Add-AppxPackage -DisableDevelopmentMode -Register "^""$manifestPath"^"" -ErrorAction Stop; Write-Host "^""Successfully installed `"^""$packageName`"^"" using its manifest file."^""; exit 0; } catch { Write-Warning "^""Error installing from manifest: $($_.Exception.Message)"^""; }; }; }; <# Attempt installation using the package family name #>; $packageFamilyName = "^""$($packageName)_$($publisherId)"^""; Write-Host "^""Trying to install `"^""$packageName`"^"" using its package family name: `"^""$packageFamilyName`"^"" from system installation..."^""; try { Add-AppxPackage -RegisterByFamilyName -MainPackage $packageFamilyName -ErrorAction Stop; Write-Host "^""Successfully installed `"^""$packageName`"^"" using its package family name."^""; exit 0; } catch { Write-Warning "^""Error installing using package family name: $($_.Exception.Message)"^""; }; throw "^""Unable to reinstall the requested package ($packageName). "^"" + "^""It appears to no longer be included in this version of Windows. "^"" + "^""You may search for it or an alternative in the Microsoft Store or "^"" + "^""consider using an earlier version of Windows where this package was originally provided."^"""
:: Remove 'Microsoft.XboxGamingOverlay' from deprovisioned list to allow reinstall during updates.
:: Restore "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Appx\AppxAllUserStore\Deprovisioned\Microsoft.XboxGamingOverlay_8wekyb3d8bbwe" registry key by deleting it
PowerShell -ExecutionPolicy Unrestricted -Command "$keyPath='HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Appx\AppxAllUserStore\Deprovisioned\Microsoft.XboxGamingOverlay_8wekyb3d8bbwe'; $registryHive = $keyPath.Split('\')[0]; $registryPath = "^""$($registryHive):$($keyPath.Substring($registryHive.Length))"^""; Write-Host "^""Removing registry key at `"^""$registryPath`"^""."^""; if (-not (Test-Path -LiteralPath $registryPath)) { Write-Host "^""Skipping, no action needed, registry key `"^""$registryPath`"^"" does not exist."^""; exit 0; }; try { Remove-Item -LiteralPath $registryPath -Force -ErrorAction Stop | Out-Null; Write-Host "^""Successfully removed the registry key at path `"^""$registryPath`"^""."^""; } catch { Write-Error "^""Failed to remove the registry key at path `"^""$registryPath`"^"": $($_.Exception.Message)"^""; }"
:: Reinstall 'Microsoft.XboxGameOverlay' if it was previously uninstalled
PowerShell -ExecutionPolicy Unrestricted -Command "$packageName='Microsoft.XboxGameOverlay'; $publisherId='8wekyb3d8bbwe'; if (Get-AppxPackage -Name $packageName) { Write-Host "^""Skipping, `"^""$packageName`"^"" is already installed for the current user."^""; exit 0; }; Write-Host "^""Starting the installation process for `"^""$packageName`"^""..."^""; <# Attempt installation using the manifest file #>; Write-Host "^""Checking if `"^""$packageName`"^"" is installed on another user profile..."^""; $packages = @(Get-AppxPackage -AllUsers $packageName); if (!$packages) { Write-Host "^""`"^""$packageName`"^"" is not installed on any other user profiles."^""; } else { foreach ($package in $packages) { Write-Host "^""Found package `"^""$($package.PackageFullName)`"^""."^""; $installationDir = $package.InstallLocation; if ([string]::IsNullOrWhiteSpace($installationDir)) { Write-Warning "^""Installation directory for `"^""$packageName`"^"" is not found or invalid."^""; continue; }; $manifestPath = Join-Path -Path $installationDir -ChildPath 'AppxManifest.xml'; try { if (-Not (Test-Path "^""$manifestPath"^"")) { Write-Host "^""Manifest file not found for `"^""$packageName`"^"" on another user profile: `"^""$manifestPath`"^""."^""; continue; }; } catch { Write-Warning "^""An error occurred while checking for the manifest file: $($_.Exception.Message)"^""; continue; }; Write-Host "^""Manifest file located. Trying to install using the manifest: `"^""$manifestPath`"^""..."^""; try { Add-AppxPackage -DisableDevelopmentMode -Register "^""$manifestPath"^"" -ErrorAction Stop; Write-Host "^""Successfully installed `"^""$packageName`"^"" using its manifest file."^""; exit 0; } catch { Write-Warning "^""Error installing from manifest: $($_.Exception.Message)"^""; }; }; }; <# Attempt installation using the package family name #>; $packageFamilyName = "^""$($packageName)_$($publisherId)"^""; Write-Host "^""Trying to install `"^""$packageName`"^"" using its package family name: `"^""$packageFamilyName`"^"" from system installation..."^""; try { Add-AppxPackage -RegisterByFamilyName -MainPackage $packageFamilyName -ErrorAction Stop; Write-Host "^""Successfully installed `"^""$packageName`"^"" using its package family name."^""; exit 0; } catch { Write-Warning "^""Error installing using package family name: $($_.Exception.Message)"^""; }; throw "^""Unable to reinstall the requested package ($packageName). "^"" + "^""It appears to no longer be included in this version of Windows. "^"" + "^""You may search for it or an alternative in the Microsoft Store or "^"" + "^""consider using an earlier version of Windows where this package was originally provided."^"""
:: Remove 'Microsoft.XboxGameOverlay' from deprovisioned list to allow reinstall during updates.
:: Restore "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Appx\AppxAllUserStore\Deprovisioned\Microsoft.XboxGameOverlay_8wekyb3d8bbwe" registry key by deleting it
PowerShell -ExecutionPolicy Unrestricted -Command "$keyPath='HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Appx\AppxAllUserStore\Deprovisioned\Microsoft.XboxGameOverlay_8wekyb3d8bbwe'; $registryHive = $keyPath.Split('\')[0]; $registryPath = "^""$($registryHive):$($keyPath.Substring($registryHive.Length))"^""; Write-Host "^""Removing registry key at `"^""$registryPath`"^""."^""; if (-not (Test-Path -LiteralPath $registryPath)) { Write-Host "^""Skipping, no action needed, registry key `"^""$registryPath`"^"" does not exist."^""; exit 0; }; try { Remove-Item -LiteralPath $registryPath -Force -ErrorAction Stop | Out-Null; Write-Host "^""Successfully removed the registry key at path `"^""$registryPath`"^""."^""; } catch { Write-Error "^""Failed to remove the registry key at path `"^""$registryPath`"^"": $($_.Exception.Message)"^""; }"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -----Remove outdated Xbox Console Companion (revert)------
:: ----------------------------------------------------------
echo --- Remove outdated Xbox Console Companion (revert)
:: Reinstall 'Microsoft.XboxApp' if it was previously uninstalled
PowerShell -ExecutionPolicy Unrestricted -Command "$packageName='Microsoft.XboxApp'; $publisherId='8wekyb3d8bbwe'; if (Get-AppxPackage -Name $packageName) { Write-Host "^""Skipping, `"^""$packageName`"^"" is already installed for the current user."^""; exit 0; }; Write-Host "^""Starting the installation process for `"^""$packageName`"^""..."^""; <# Attempt installation using the manifest file #>; Write-Host "^""Checking if `"^""$packageName`"^"" is installed on another user profile..."^""; $packages = @(Get-AppxPackage -AllUsers $packageName); if (!$packages) { Write-Host "^""`"^""$packageName`"^"" is not installed on any other user profiles."^""; } else { foreach ($package in $packages) { Write-Host "^""Found package `"^""$($package.PackageFullName)`"^""."^""; $installationDir = $package.InstallLocation; if ([string]::IsNullOrWhiteSpace($installationDir)) { Write-Warning "^""Installation directory for `"^""$packageName`"^"" is not found or invalid."^""; continue; }; $manifestPath = Join-Path -Path $installationDir -ChildPath 'AppxManifest.xml'; try { if (-Not (Test-Path "^""$manifestPath"^"")) { Write-Host "^""Manifest file not found for `"^""$packageName`"^"" on another user profile: `"^""$manifestPath`"^""."^""; continue; }; } catch { Write-Warning "^""An error occurred while checking for the manifest file: $($_.Exception.Message)"^""; continue; }; Write-Host "^""Manifest file located. Trying to install using the manifest: `"^""$manifestPath`"^""..."^""; try { Add-AppxPackage -DisableDevelopmentMode -Register "^""$manifestPath"^"" -ErrorAction Stop; Write-Host "^""Successfully installed `"^""$packageName`"^"" using its manifest file."^""; exit 0; } catch { Write-Warning "^""Error installing from manifest: $($_.Exception.Message)"^""; }; }; }; <# Attempt installation using the package family name #>; $packageFamilyName = "^""$($packageName)_$($publisherId)"^""; Write-Host "^""Trying to install `"^""$packageName`"^"" using its package family name: `"^""$packageFamilyName`"^"" from system installation..."^""; try { Add-AppxPackage -RegisterByFamilyName -MainPackage $packageFamilyName -ErrorAction Stop; Write-Host "^""Successfully installed `"^""$packageName`"^"" using its package family name."^""; exit 0; } catch { Write-Warning "^""Error installing using package family name: $($_.Exception.Message)"^""; }; throw "^""Unable to reinstall the requested package ($packageName). "^"" + "^""It appears to no longer be included in this version of Windows. "^"" + "^""You may search for it or an alternative in the Microsoft Store or "^"" + "^""consider using an earlier version of Windows where this package was originally provided."^"""
:: Remove 'Microsoft.XboxApp' from deprovisioned list to allow reinstall during updates.
:: Restore "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Appx\AppxAllUserStore\Deprovisioned\Microsoft.XboxApp_8wekyb3d8bbwe" registry key by deleting it
PowerShell -ExecutionPolicy Unrestricted -Command "$keyPath='HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Appx\AppxAllUserStore\Deprovisioned\Microsoft.XboxApp_8wekyb3d8bbwe'; $registryHive = $keyPath.Split('\')[0]; $registryPath = "^""$($registryHive):$($keyPath.Substring($registryHive.Length))"^""; Write-Host "^""Removing registry key at `"^""$registryPath`"^""."^""; if (-not (Test-Path -LiteralPath $registryPath)) { Write-Host "^""Skipping, no action needed, registry key `"^""$registryPath`"^"" does not exist."^""; exit 0; }; try { Remove-Item -LiteralPath $registryPath -Force -ErrorAction Stop | Out-Null; Write-Host "^""Successfully removed the registry key at path `"^""$registryPath`"^""."^""; } catch { Write-Error "^""Failed to remove the registry key at path `"^""$registryPath`"^"": $($_.Exception.Message)"^""; }"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -------Remove Xbox Live in-game experience (revert)-------
:: ----------------------------------------------------------
echo --- Remove Xbox Live in-game experience (revert)
:: Reinstall 'Microsoft.Xbox.TCUI' if it was previously uninstalled
PowerShell -ExecutionPolicy Unrestricted -Command "$packageName='Microsoft.Xbox.TCUI'; $publisherId='8wekyb3d8bbwe'; if (Get-AppxPackage -Name $packageName) { Write-Host "^""Skipping, `"^""$packageName`"^"" is already installed for the current user."^""; exit 0; }; Write-Host "^""Starting the installation process for `"^""$packageName`"^""..."^""; <# Attempt installation using the manifest file #>; Write-Host "^""Checking if `"^""$packageName`"^"" is installed on another user profile..."^""; $packages = @(Get-AppxPackage -AllUsers $packageName); if (!$packages) { Write-Host "^""`"^""$packageName`"^"" is not installed on any other user profiles."^""; } else { foreach ($package in $packages) { Write-Host "^""Found package `"^""$($package.PackageFullName)`"^""."^""; $installationDir = $package.InstallLocation; if ([string]::IsNullOrWhiteSpace($installationDir)) { Write-Warning "^""Installation directory for `"^""$packageName`"^"" is not found or invalid."^""; continue; }; $manifestPath = Join-Path -Path $installationDir -ChildPath 'AppxManifest.xml'; try { if (-Not (Test-Path "^""$manifestPath"^"")) { Write-Host "^""Manifest file not found for `"^""$packageName`"^"" on another user profile: `"^""$manifestPath`"^""."^""; continue; }; } catch { Write-Warning "^""An error occurred while checking for the manifest file: $($_.Exception.Message)"^""; continue; }; Write-Host "^""Manifest file located. Trying to install using the manifest: `"^""$manifestPath`"^""..."^""; try { Add-AppxPackage -DisableDevelopmentMode -Register "^""$manifestPath"^"" -ErrorAction Stop; Write-Host "^""Successfully installed `"^""$packageName`"^"" using its manifest file."^""; exit 0; } catch { Write-Warning "^""Error installing from manifest: $($_.Exception.Message)"^""; }; }; }; <# Attempt installation using the package family name #>; $packageFamilyName = "^""$($packageName)_$($publisherId)"^""; Write-Host "^""Trying to install `"^""$packageName`"^"" using its package family name: `"^""$packageFamilyName`"^"" from system installation..."^""; try { Add-AppxPackage -RegisterByFamilyName -MainPackage $packageFamilyName -ErrorAction Stop; Write-Host "^""Successfully installed `"^""$packageName`"^"" using its package family name."^""; exit 0; } catch { Write-Warning "^""Error installing using package family name: $($_.Exception.Message)"^""; }; throw "^""Unable to reinstall the requested package ($packageName). "^"" + "^""It appears to no longer be included in this version of Windows. "^"" + "^""You may search for it or an alternative in the Microsoft Store or "^"" + "^""consider using an earlier version of Windows where this package was originally provided."^"""
:: Remove 'Microsoft.Xbox.TCUI' from deprovisioned list to allow reinstall during updates.
:: Restore "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Appx\AppxAllUserStore\Deprovisioned\Microsoft.Xbox.TCUI_8wekyb3d8bbwe" registry key by deleting it
PowerShell -ExecutionPolicy Unrestricted -Command "$keyPath='HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Appx\AppxAllUserStore\Deprovisioned\Microsoft.Xbox.TCUI_8wekyb3d8bbwe'; $registryHive = $keyPath.Split('\')[0]; $registryPath = "^""$($registryHive):$($keyPath.Substring($registryHive.Length))"^""; Write-Host "^""Removing registry key at `"^""$registryPath`"^""."^""; if (-not (Test-Path -LiteralPath $registryPath)) { Write-Host "^""Skipping, no action needed, registry key `"^""$registryPath`"^"" does not exist."^""; exit 0; }; try { Remove-Item -LiteralPath $registryPath -Force -ErrorAction Stop | Out-Null; Write-Host "^""Successfully removed the registry key at path `"^""$registryPath`"^""."^""; } catch { Write-Error "^""Failed to remove the registry key at path `"^""$registryPath`"^"": $($_.Exception.Message)"^""; }"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -------Remove Xbox Speech To Text Overlay (revert)--------
:: ----------------------------------------------------------
echo --- Remove Xbox Speech To Text Overlay (revert)
:: Reinstall 'Microsoft.XboxSpeechToTextOverlay' if it was previously uninstalled
PowerShell -ExecutionPolicy Unrestricted -Command "$packageName='Microsoft.XboxSpeechToTextOverlay'; $publisherId='8wekyb3d8bbwe'; if (Get-AppxPackage -Name $packageName) { Write-Host "^""Skipping, `"^""$packageName`"^"" is already installed for the current user."^""; exit 0; }; Write-Host "^""Starting the installation process for `"^""$packageName`"^""..."^""; <# Attempt installation using the manifest file #>; Write-Host "^""Checking if `"^""$packageName`"^"" is installed on another user profile..."^""; $packages = @(Get-AppxPackage -AllUsers $packageName); if (!$packages) { Write-Host "^""`"^""$packageName`"^"" is not installed on any other user profiles."^""; } else { foreach ($package in $packages) { Write-Host "^""Found package `"^""$($package.PackageFullName)`"^""."^""; $installationDir = $package.InstallLocation; if ([string]::IsNullOrWhiteSpace($installationDir)) { Write-Warning "^""Installation directory for `"^""$packageName`"^"" is not found or invalid."^""; continue; }; $manifestPath = Join-Path -Path $installationDir -ChildPath 'AppxManifest.xml'; try { if (-Not (Test-Path "^""$manifestPath"^"")) { Write-Host "^""Manifest file not found for `"^""$packageName`"^"" on another user profile: `"^""$manifestPath`"^""."^""; continue; }; } catch { Write-Warning "^""An error occurred while checking for the manifest file: $($_.Exception.Message)"^""; continue; }; Write-Host "^""Manifest file located. Trying to install using the manifest: `"^""$manifestPath`"^""..."^""; try { Add-AppxPackage -DisableDevelopmentMode -Register "^""$manifestPath"^"" -ErrorAction Stop; Write-Host "^""Successfully installed `"^""$packageName`"^"" using its manifest file."^""; exit 0; } catch { Write-Warning "^""Error installing from manifest: $($_.Exception.Message)"^""; }; }; }; <# Attempt installation using the package family name #>; $packageFamilyName = "^""$($packageName)_$($publisherId)"^""; Write-Host "^""Trying to install `"^""$packageName`"^"" using its package family name: `"^""$packageFamilyName`"^"" from system installation..."^""; try { Add-AppxPackage -RegisterByFamilyName -MainPackage $packageFamilyName -ErrorAction Stop; Write-Host "^""Successfully installed `"^""$packageName`"^"" using its package family name."^""; exit 0; } catch { Write-Warning "^""Error installing using package family name: $($_.Exception.Message)"^""; }; throw "^""Unable to reinstall the requested package ($packageName). "^"" + "^""It appears to no longer be included in this version of Windows. "^"" + "^""You may search for it or an alternative in the Microsoft Store or "^"" + "^""consider using an earlier version of Windows where this package was originally provided."^"""
:: Remove 'Microsoft.XboxSpeechToTextOverlay' from deprovisioned list to allow reinstall during updates.
:: Restore "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Appx\AppxAllUserStore\Deprovisioned\Microsoft.XboxSpeechToTextOverlay_8wekyb3d8bbwe" registry key by deleting it
PowerShell -ExecutionPolicy Unrestricted -Command "$keyPath='HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Appx\AppxAllUserStore\Deprovisioned\Microsoft.XboxSpeechToTextOverlay_8wekyb3d8bbwe'; $registryHive = $keyPath.Split('\')[0]; $registryPath = "^""$($registryHive):$($keyPath.Substring($registryHive.Length))"^""; Write-Host "^""Removing registry key at `"^""$registryPath`"^""."^""; if (-not (Test-Path -LiteralPath $registryPath)) { Write-Host "^""Skipping, no action needed, registry key `"^""$registryPath`"^"" does not exist."^""; exit 0; }; try { Remove-Item -LiteralPath $registryPath -Force -ErrorAction Stop | Out-Null; Write-Host "^""Successfully removed the registry key at path `"^""$registryPath`"^""."^""; } catch { Write-Error "^""Failed to remove the registry key at path `"^""$registryPath`"^"": $($_.Exception.Message)"^""; }"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -----------Disable Xbox Live Game Save (revert)-----------
:: ----------------------------------------------------------
echo --- Disable Xbox Live Game Save (revert)
:: Restore service(s) to default state: `XblGameSave`
PowerShell -ExecutionPolicy Unrestricted -Command "$serviceName = 'XblGameSave'; $defaultStartupMode = 'Manual'; $ignoreMissingOnRevert =  $false; Write-Host "^""Reverting service `"^""$serviceName`"^"" start to `"^""$defaultStartupMode`"^""."^""; <# -- 1. Skip if service does not exist #>; $service = Get-Service -Name $serviceName -ErrorAction SilentlyContinue; if (!$service) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The service `"^""$serviceName`"^"" is not found. No action required."^""; Exit 0; }; Write-Warning "^""Failed to revert changes to the service `"^""$serviceName`"^"". The service is not found."^""; Exit 1; }; <# -- 2. Enable or skip if already enabled #>; $startupType = $service.StartType <# Does not work before .NET 4.6.1 #>; if (!$startupType) { $startupType = (Get-WmiObject -Query "^""Select StartMode From Win32_Service Where Name='$serviceName'"^"" -ErrorAction Ignore).StartMode; if (!$startupType) { $startupType = (Get-WmiObject -Class Win32_Service -Property StartMode -Filter "^""Name='$serviceName'"^"" -ErrorAction Ignore).StartMode; }; }; if ($startupType -eq "^""$defaultStartupMode"^"") { Write-Host "^""`"^""$serviceName`"^"" has already expected startup mode: `"^""$defaultStartupMode`"^"". No action required."^""; } else { try { Set-Service -Name "^""$serviceName"^"" -StartupType "^""$defaultStartupMode"^"" -Confirm:$false -ErrorAction Stop; Write-Host "^""Reverted `"^""$serviceName`"^"" with `"^""$defaultStartupMode`"^"" start, this may require restarting your computer."^""; } catch { Write-Error "^""Failed to enable `"^""$serviceName`"^"": $_"^""; Exit 1; }; }; <# -- 4. Start if not running (must be enabled first) #>; if ($defaultStartupMode -eq 'Automatic' -or $defaultStartupMode -eq 'Boot' -or $defaultStartupMode -eq 'System') { if ($service.Status -ne [System.ServiceProcess.ServiceControllerStatus]::Running) { Write-Host "^""`"^""$serviceName`"^"" is not running, starting it."^""; try { Start-Service $serviceName -ErrorAction Stop; Write-Host "^""Started `"^""$serviceName`"^"" successfully."^""; } catch { Write-Warning "^""Failed to start `"^""$serviceName`"^"", requires restart, it will be started after reboot.`r`n$_"^""; }; } else { Write-Host "^""`"^""$serviceName`"^"" is already running, no need to start."^""; }; }"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ------Disable Xbox Live Networking Service (revert)-------
:: ----------------------------------------------------------
echo --- Disable Xbox Live Networking Service (revert)
:: Restore service(s) to default state: `XboxNetApiSvc`
PowerShell -ExecutionPolicy Unrestricted -Command "$serviceName = 'XboxNetApiSvc'; $defaultStartupMode = 'Manual'; $ignoreMissingOnRevert =  $false; Write-Host "^""Reverting service `"^""$serviceName`"^"" start to `"^""$defaultStartupMode`"^""."^""; <# -- 1. Skip if service does not exist #>; $service = Get-Service -Name $serviceName -ErrorAction SilentlyContinue; if (!$service) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The service `"^""$serviceName`"^"" is not found. No action required."^""; Exit 0; }; Write-Warning "^""Failed to revert changes to the service `"^""$serviceName`"^"". The service is not found."^""; Exit 1; }; <# -- 2. Enable or skip if already enabled #>; $startupType = $service.StartType <# Does not work before .NET 4.6.1 #>; if (!$startupType) { $startupType = (Get-WmiObject -Query "^""Select StartMode From Win32_Service Where Name='$serviceName'"^"" -ErrorAction Ignore).StartMode; if (!$startupType) { $startupType = (Get-WmiObject -Class Win32_Service -Property StartMode -Filter "^""Name='$serviceName'"^"" -ErrorAction Ignore).StartMode; }; }; if ($startupType -eq "^""$defaultStartupMode"^"") { Write-Host "^""`"^""$serviceName`"^"" has already expected startup mode: `"^""$defaultStartupMode`"^"". No action required."^""; } else { try { Set-Service -Name "^""$serviceName"^"" -StartupType "^""$defaultStartupMode"^"" -Confirm:$false -ErrorAction Stop; Write-Host "^""Reverted `"^""$serviceName`"^"" with `"^""$defaultStartupMode`"^"" start, this may require restarting your computer."^""; } catch { Write-Error "^""Failed to enable `"^""$serviceName`"^"": $_"^""; Exit 1; }; }; <# -- 4. Start if not running (must be enabled first) #>; if ($defaultStartupMode -eq 'Automatic' -or $defaultStartupMode -eq 'Boot' -or $defaultStartupMode -eq 'System') { if ($service.Status -ne [System.ServiceProcess.ServiceControllerStatus]::Running) { Write-Host "^""`"^""$serviceName`"^"" is not running, starting it."^""; try { Start-Service $serviceName -ErrorAction Stop; Write-Host "^""Started `"^""$serviceName`"^"" successfully."^""; } catch { Write-Warning "^""Failed to start `"^""$serviceName`"^"", requires restart, it will be started after reboot.`r`n$_"^""; }; } else { Write-Host "^""`"^""$serviceName`"^"" is already running, no need to start."^""; }; }"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ---------Disable Xbox Live Auth Manager (revert)----------
:: ----------------------------------------------------------
echo --- Disable Xbox Live Auth Manager (revert)
:: Restore service(s) to default state: `XblAuthManager`
PowerShell -ExecutionPolicy Unrestricted -Command "$serviceName = 'XblAuthManager'; $defaultStartupMode = 'Manual'; $ignoreMissingOnRevert =  $false; Write-Host "^""Reverting service `"^""$serviceName`"^"" start to `"^""$defaultStartupMode`"^""."^""; <# -- 1. Skip if service does not exist #>; $service = Get-Service -Name $serviceName -ErrorAction SilentlyContinue; if (!$service) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The service `"^""$serviceName`"^"" is not found. No action required."^""; Exit 0; }; Write-Warning "^""Failed to revert changes to the service `"^""$serviceName`"^"". The service is not found."^""; Exit 1; }; <# -- 2. Enable or skip if already enabled #>; $startupType = $service.StartType <# Does not work before .NET 4.6.1 #>; if (!$startupType) { $startupType = (Get-WmiObject -Query "^""Select StartMode From Win32_Service Where Name='$serviceName'"^"" -ErrorAction Ignore).StartMode; if (!$startupType) { $startupType = (Get-WmiObject -Class Win32_Service -Property StartMode -Filter "^""Name='$serviceName'"^"" -ErrorAction Ignore).StartMode; }; }; if ($startupType -eq "^""$defaultStartupMode"^"") { Write-Host "^""`"^""$serviceName`"^"" has already expected startup mode: `"^""$defaultStartupMode`"^"". No action required."^""; } else { try { Set-Service -Name "^""$serviceName"^"" -StartupType "^""$defaultStartupMode"^"" -Confirm:$false -ErrorAction Stop; Write-Host "^""Reverted `"^""$serviceName`"^"" with `"^""$defaultStartupMode`"^"" start, this may require restarting your computer."^""; } catch { Write-Error "^""Failed to enable `"^""$serviceName`"^"": $_"^""; Exit 1; }; }; <# -- 4. Start if not running (must be enabled first) #>; if ($defaultStartupMode -eq 'Automatic' -or $defaultStartupMode -eq 'Boot' -or $defaultStartupMode -eq 'System') { if ($service.Status -ne [System.ServiceProcess.ServiceControllerStatus]::Running) { Write-Host "^""`"^""$serviceName`"^"" is not running, starting it."^""; try { Start-Service $serviceName -ErrorAction Stop; Write-Host "^""Started `"^""$serviceName`"^"" successfully."^""; } catch { Write-Warning "^""Failed to start `"^""$serviceName`"^"", requires restart, it will be started after reboot.`r`n$_"^""; }; } else { Write-Host "^""`"^""$serviceName`"^"" is already running, no need to start."^""; }; }"
:: ----------------------------------------------------------


:: Remove Xbox Identity Provider (breaks Xbox sign-in) (revert)
echo --- Remove Xbox Identity Provider (breaks Xbox sign-in) (revert)
:: Reinstall 'Microsoft.XboxIdentityProvider' if it was previously uninstalled
PowerShell -ExecutionPolicy Unrestricted -Command "$packageName='Microsoft.XboxIdentityProvider'; $publisherId='8wekyb3d8bbwe'; if (Get-AppxPackage -Name $packageName) { Write-Host "^""Skipping, `"^""$packageName`"^"" is already installed for the current user."^""; exit 0; }; Write-Host "^""Starting the installation process for `"^""$packageName`"^""..."^""; <# Attempt installation using the manifest file #>; Write-Host "^""Checking if `"^""$packageName`"^"" is installed on another user profile..."^""; $packages = @(Get-AppxPackage -AllUsers $packageName); if (!$packages) { Write-Host "^""`"^""$packageName`"^"" is not installed on any other user profiles."^""; } else { foreach ($package in $packages) { Write-Host "^""Found package `"^""$($package.PackageFullName)`"^""."^""; $installationDir = $package.InstallLocation; if ([string]::IsNullOrWhiteSpace($installationDir)) { Write-Warning "^""Installation directory for `"^""$packageName`"^"" is not found or invalid."^""; continue; }; $manifestPath = Join-Path -Path $installationDir -ChildPath 'AppxManifest.xml'; try { if (-Not (Test-Path "^""$manifestPath"^"")) { Write-Host "^""Manifest file not found for `"^""$packageName`"^"" on another user profile: `"^""$manifestPath`"^""."^""; continue; }; } catch { Write-Warning "^""An error occurred while checking for the manifest file: $($_.Exception.Message)"^""; continue; }; Write-Host "^""Manifest file located. Trying to install using the manifest: `"^""$manifestPath`"^""..."^""; try { Add-AppxPackage -DisableDevelopmentMode -Register "^""$manifestPath"^"" -ErrorAction Stop; Write-Host "^""Successfully installed `"^""$packageName`"^"" using its manifest file."^""; exit 0; } catch { Write-Warning "^""Error installing from manifest: $($_.Exception.Message)"^""; }; }; }; <# Attempt installation using the package family name #>; $packageFamilyName = "^""$($packageName)_$($publisherId)"^""; Write-Host "^""Trying to install `"^""$packageName`"^"" using its package family name: `"^""$packageFamilyName`"^"" from system installation..."^""; try { Add-AppxPackage -RegisterByFamilyName -MainPackage $packageFamilyName -ErrorAction Stop; Write-Host "^""Successfully installed `"^""$packageName`"^"" using its package family name."^""; exit 0; } catch { Write-Warning "^""Error installing using package family name: $($_.Exception.Message)"^""; }; throw "^""Unable to reinstall the requested package ($packageName). "^"" + "^""It appears to no longer be included in this version of Windows. "^"" + "^""You may search for it or an alternative in the Microsoft Store or "^"" + "^""consider using an earlier version of Windows where this package was originally provided."^"""
:: Remove 'Microsoft.XboxIdentityProvider' from deprovisioned list to allow reinstall during updates.
:: Restore "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Appx\AppxAllUserStore\Deprovisioned\Microsoft.XboxIdentityProvider_8wekyb3d8bbwe" registry key by deleting it
PowerShell -ExecutionPolicy Unrestricted -Command "$keyPath='HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Appx\AppxAllUserStore\Deprovisioned\Microsoft.XboxIdentityProvider_8wekyb3d8bbwe'; $registryHive = $keyPath.Split('\')[0]; $registryPath = "^""$($registryHive):$($keyPath.Substring($registryHive.Length))"^""; Write-Host "^""Removing registry key at `"^""$registryPath`"^""."^""; if (-not (Test-Path -LiteralPath $registryPath)) { Write-Host "^""Skipping, no action needed, registry key `"^""$registryPath`"^"" does not exist."^""; exit 0; }; try { Remove-Item -LiteralPath $registryPath -Force -ErrorAction Stop | Out-Null; Write-Host "^""Successfully removed the registry key at path `"^""$registryPath`"^""."^""; } catch { Write-Error "^""Failed to remove the registry key at path `"^""$registryPath`"^"": $($_.Exception.Message)"^""; }"
:: ----------------------------------------------------------


:: Remove "Xbox Game Callable UI" app (breaks Xbox Live games) (revert)
echo --- Remove "Xbox Game Callable UI" app (breaks Xbox Live games) (revert)
:: Restore files matching pattern: "%SYSTEMROOT%\SystemApps\Microsoft.XboxGameCallableUI_cw5n1h2txyewy\*" with additional permissions 
PowerShell -ExecutionPolicy Unrestricted -Command "$revert = $true; $pathGlobPattern = "^""%SYSTEMROOT%\SystemApps\Microsoft.XboxGameCallableUI_cw5n1h2txyewy\*.OLD"^""; $expandedPath = [System.Environment]::ExpandEnvironmentVariables($pathGlobPattern); Write-Host "^""Searching for items matching pattern: `"^""$($expandedPath)`"^""."^""; $renamedCount   = 0; $skippedCount   = 0; $failedCount    = 0; Add-Type -TypeDefinition "^""using System;`r`nusing System.Runtime.InteropServices;`r`npublic class Privileges {`r`n    [DllImport(`"^""advapi32.dll`"^"", ExactSpelling = true, SetLastError = true)]`r`n    internal static extern bool AdjustTokenPrivileges(IntPtr htok, bool disall,`r`n        ref TokPriv1Luid newst, int len, IntPtr prev, IntPtr relen);`r`n    [DllImport(`"^""advapi32.dll`"^"", ExactSpelling = true, SetLastError = true)]`r`n    internal static extern bool OpenProcessToken(IntPtr h, int acc, ref IntPtr phtok);`r`n    [DllImport(`"^""advapi32.dll`"^"", SetLastError = true)]`r`n    internal static extern bool LookupPrivilegeValue(string host, string name, ref long pluid);`r`n    [StructLayout(LayoutKind.Sequential, Pack = 1)]`r`n    internal struct TokPriv1Luid {`r`n        public int Count;`r`n        public long Luid;`r`n        public int Attr;`r`n    }`r`n    internal const int SE_PRIVILEGE_ENABLED = 0x00000002;`r`n    internal const int TOKEN_QUERY = 0x00000008;`r`n    internal const int TOKEN_ADJUST_PRIVILEGES = 0x00000020;`r`n    public static bool AddPrivilege(string privilege) {`r`n        try {`r`n            bool retVal;`r`n            TokPriv1Luid tp;`r`n            IntPtr hproc = GetCurrentProcess();`r`n            IntPtr htok = IntPtr.Zero;`r`n            retVal = OpenProcessToken(hproc, TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, ref htok);`r`n            tp.Count = 1;`r`n            tp.Luid = 0;`r`n            tp.Attr = SE_PRIVILEGE_ENABLED;`r`n            retVal = LookupPrivilegeValue(null, privilege, ref tp.Luid);`r`n            retVal = AdjustTokenPrivileges(htok, false, ref tp, 0, IntPtr.Zero, IntPtr.Zero);`r`n            return retVal;`r`n        } catch (Exception ex) {`r`n            throw new Exception(`"^""Failed to adjust token privileges`"^"", ex);`r`n        }`r`n    }`r`n    public static bool RemovePrivilege(string privilege) {`r`n        try {`r`n            bool retVal;`r`n            TokPriv1Luid tp;`r`n            IntPtr hproc = GetCurrentProcess();`r`n            IntPtr htok = IntPtr.Zero;`r`n            retVal = OpenProcessToken(hproc, TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, ref htok);`r`n            tp.Count = 1;`r`n            tp.Luid = 0;`r`n            tp.Attr = 0;  // This line is changed to revoke the privilege`r`n            retVal = LookupPrivilegeValue(null, privilege, ref tp.Luid);`r`n            retVal = AdjustTokenPrivileges(htok, false, ref tp, 0, IntPtr.Zero, IntPtr.Zero);`r`n            return retVal;`r`n        } catch (Exception ex) {`r`n            throw new Exception(`"^""Failed to adjust token privileges`"^"", ex);`r`n        }`r`n    }`r`n    [DllImport(`"^""kernel32.dll`"^"", CharSet = CharSet.Auto)]`r`n    public static extern IntPtr GetCurrentProcess();`r`n}"^""; [Privileges]::AddPrivilege('SeRestorePrivilege') | Out-Null; [Privileges]::AddPrivilege('SeTakeOwnershipPrivilege') | Out-Null; $adminSid = New-Object System.Security.Principal.SecurityIdentifier 'S-1-5-32-544'; $adminAccount = $adminSid.Translate([System.Security.Principal.NTAccount]); $adminFullControlAccessRule = New-Object System.Security.AccessControl.FileSystemAccessRule( $adminAccount, [System.Security.AccessControl.FileSystemRights]::FullControl, [System.Security.AccessControl.AccessControlType]::Allow ); $foundAbsolutePaths = @(); Write-Host 'Iterating files and directories recursively.'; try { $foundAbsolutePaths += @(; Get-ChildItem -Path $expandedPath -Force -Recurse -ErrorAction Stop | Select-Object -ExpandProperty FullName; ); } catch [System.Management.Automation.ItemNotFoundException] { <# Swallow, do not run `Test-Path` before, it's unreliable for globs requiring extra permissions #>; }; try { $foundAbsolutePaths += @(; Get-Item -Path $expandedPath -ErrorAction Stop | Select-Object -ExpandProperty FullName; ); } catch [System.Management.Automation.ItemNotFoundException] { <# Swallow, do not run `Test-Path` before, it's unreliable for globs requiring extra permissions #>; }; $foundAbsolutePaths = $foundAbsolutePaths | Select-Object -Unique | Sort-Object -Property { $_.Length } -Descending; if (!$foundAbsolutePaths) { Write-Host 'Skipping, no items available.'; exit 0; }; Write-Host "^""Initiating processing of $($foundAbsolutePaths.Count) items from `"^""$expandedPath`"^""."^""; foreach ($path in $foundAbsolutePaths) { if (Test-Path -Path $path -PathType Container) { Write-Host "^""Skipping folder (not its contents): `"^""$path`"^""."^""; $skippedCount++; continue; }; if($revert -eq $true) { if (-not $path.EndsWith('.OLD')) { Write-Host "^""Skipping non-backup file: `"^""$path`"^""."^""; $skippedCount++; continue; }; } else { if ($path.EndsWith('.OLD')) { Write-Host "^""Skipping backup file: `"^""$path`"^""."^""; $skippedCount++; continue; }; }; $originalFilePath = $path; Write-Host "^""Processing file: `"^""$originalFilePath`"^""."^""; if (-Not (Test-Path $originalFilePath)) { Write-Host "^""Skipping, file `"^""$originalFilePath`"^"" not found."^""; $skippedCount++; exit 0; }; $originalAcl = Get-Acl -Path "^""$originalFilePath"^""; $accessGranted = $false; try { $acl = Get-Acl -Path "^""$originalFilePath"^""; $acl.SetOwner($adminAccount) <# Take Ownership (because file is owned by TrustedInstaller) #>; $acl.AddAccessRule($adminFullControlAccessRule) <# Grant rights to be able to move the file #>; Set-Acl -Path $originalFilePath -AclObject $acl -ErrorAction Stop; $accessGranted = $true; } catch { Write-Warning "^""Failed to grant access to `"^""$originalFilePath`"^"": $($_.Exception.Message)"^""; }; if ($revert -eq $true) { $newFilePath = $originalFilePath.Substring(0, $originalFilePath.Length - 4); } else { $newFilePath = "^""$($originalFilePath).OLD"^""; }; try { Move-Item -LiteralPath "^""$($originalFilePath)"^"" -Destination "^""$newFilePath"^"" -Force -ErrorAction Stop; Write-Host "^""Successfully processed `"^""$originalFilePath`"^""."^""; $renamedCount++; if ($accessGranted) { try { Set-Acl -Path $newFilePath -AclObject $originalAcl -ErrorAction Stop; } catch { Write-Warning "^""Failed to restore access on `"^""$newFilePath`"^"": $($_.Exception.Message)"^""; }; }; } catch { Write-Error "^""Failed to rename `"^""$originalFilePath`"^"" to `"^""$newFilePath`"^"": $($_.Exception.Message)"^""; $failedCount++; if ($accessGranted) { try { Set-Acl -Path $originalFilePath -AclObject $originalAcl -ErrorAction Stop; } catch { Write-Warning "^""Failed to restore access on `"^""$originalFilePath`"^"": $($_.Exception.Message)"^""; }; }; }; }; if (($renamedCount -gt 0) -or ($skippedCount -gt 0)) { Write-Host "^""Successfully processed $renamedCount items and skipped $skippedCount items."^""; }; if ($failedCount -gt 0) { Write-Warning "^""Failed to process $($failedCount) items."^""; }; [Privileges]::RemovePrivilege('SeRestorePrivilege') | Out-Null; [Privileges]::RemovePrivilege('SeTakeOwnershipPrivilege') | Out-Null"
:: Restore files matching pattern: "%SYSTEMROOT%\$(("Microsoft.XboxGameCallableUI" -Split '\.')[-1])\*" with additional permissions 
PowerShell -ExecutionPolicy Unrestricted -Command "$revert = $true; $pathGlobPattern = "^""%SYSTEMROOT%\$(("^""Microsoft.XboxGameCallableUI"^"" -Split '\.')[-1])\*.OLD"^""; $expandedPath = [System.Environment]::ExpandEnvironmentVariables($pathGlobPattern); Write-Host "^""Searching for items matching pattern: `"^""$($expandedPath)`"^""."^""; $renamedCount   = 0; $skippedCount   = 0; $failedCount    = 0; Add-Type -TypeDefinition "^""using System;`r`nusing System.Runtime.InteropServices;`r`npublic class Privileges {`r`n    [DllImport(`"^""advapi32.dll`"^"", ExactSpelling = true, SetLastError = true)]`r`n    internal static extern bool AdjustTokenPrivileges(IntPtr htok, bool disall,`r`n        ref TokPriv1Luid newst, int len, IntPtr prev, IntPtr relen);`r`n    [DllImport(`"^""advapi32.dll`"^"", ExactSpelling = true, SetLastError = true)]`r`n    internal static extern bool OpenProcessToken(IntPtr h, int acc, ref IntPtr phtok);`r`n    [DllImport(`"^""advapi32.dll`"^"", SetLastError = true)]`r`n    internal static extern bool LookupPrivilegeValue(string host, string name, ref long pluid);`r`n    [StructLayout(LayoutKind.Sequential, Pack = 1)]`r`n    internal struct TokPriv1Luid {`r`n        public int Count;`r`n        public long Luid;`r`n        public int Attr;`r`n    }`r`n    internal const int SE_PRIVILEGE_ENABLED = 0x00000002;`r`n    internal const int TOKEN_QUERY = 0x00000008;`r`n    internal const int TOKEN_ADJUST_PRIVILEGES = 0x00000020;`r`n    public static bool AddPrivilege(string privilege) {`r`n        try {`r`n            bool retVal;`r`n            TokPriv1Luid tp;`r`n            IntPtr hproc = GetCurrentProcess();`r`n            IntPtr htok = IntPtr.Zero;`r`n            retVal = OpenProcessToken(hproc, TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, ref htok);`r`n            tp.Count = 1;`r`n            tp.Luid = 0;`r`n            tp.Attr = SE_PRIVILEGE_ENABLED;`r`n            retVal = LookupPrivilegeValue(null, privilege, ref tp.Luid);`r`n            retVal = AdjustTokenPrivileges(htok, false, ref tp, 0, IntPtr.Zero, IntPtr.Zero);`r`n            return retVal;`r`n        } catch (Exception ex) {`r`n            throw new Exception(`"^""Failed to adjust token privileges`"^"", ex);`r`n        }`r`n    }`r`n    public static bool RemovePrivilege(string privilege) {`r`n        try {`r`n            bool retVal;`r`n            TokPriv1Luid tp;`r`n            IntPtr hproc = GetCurrentProcess();`r`n            IntPtr htok = IntPtr.Zero;`r`n            retVal = OpenProcessToken(hproc, TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, ref htok);`r`n            tp.Count = 1;`r`n            tp.Luid = 0;`r`n            tp.Attr = 0;  // This line is changed to revoke the privilege`r`n            retVal = LookupPrivilegeValue(null, privilege, ref tp.Luid);`r`n            retVal = AdjustTokenPrivileges(htok, false, ref tp, 0, IntPtr.Zero, IntPtr.Zero);`r`n            return retVal;`r`n        } catch (Exception ex) {`r`n            throw new Exception(`"^""Failed to adjust token privileges`"^"", ex);`r`n        }`r`n    }`r`n    [DllImport(`"^""kernel32.dll`"^"", CharSet = CharSet.Auto)]`r`n    public static extern IntPtr GetCurrentProcess();`r`n}"^""; [Privileges]::AddPrivilege('SeRestorePrivilege') | Out-Null; [Privileges]::AddPrivilege('SeTakeOwnershipPrivilege') | Out-Null; $adminSid = New-Object System.Security.Principal.SecurityIdentifier 'S-1-5-32-544'; $adminAccount = $adminSid.Translate([System.Security.Principal.NTAccount]); $adminFullControlAccessRule = New-Object System.Security.AccessControl.FileSystemAccessRule( $adminAccount, [System.Security.AccessControl.FileSystemRights]::FullControl, [System.Security.AccessControl.AccessControlType]::Allow ); $foundAbsolutePaths = @(); Write-Host 'Iterating files and directories recursively.'; try { $foundAbsolutePaths += @(; Get-ChildItem -Path $expandedPath -Force -Recurse -ErrorAction Stop | Select-Object -ExpandProperty FullName; ); } catch [System.Management.Automation.ItemNotFoundException] { <# Swallow, do not run `Test-Path` before, it's unreliable for globs requiring extra permissions #>; }; try { $foundAbsolutePaths += @(; Get-Item -Path $expandedPath -ErrorAction Stop | Select-Object -ExpandProperty FullName; ); } catch [System.Management.Automation.ItemNotFoundException] { <# Swallow, do not run `Test-Path` before, it's unreliable for globs requiring extra permissions #>; }; $foundAbsolutePaths = $foundAbsolutePaths | Select-Object -Unique | Sort-Object -Property { $_.Length } -Descending; if (!$foundAbsolutePaths) { Write-Host 'Skipping, no items available.'; exit 0; }; Write-Host "^""Initiating processing of $($foundAbsolutePaths.Count) items from `"^""$expandedPath`"^""."^""; foreach ($path in $foundAbsolutePaths) { if (Test-Path -Path $path -PathType Container) { Write-Host "^""Skipping folder (not its contents): `"^""$path`"^""."^""; $skippedCount++; continue; }; if($revert -eq $true) { if (-not $path.EndsWith('.OLD')) { Write-Host "^""Skipping non-backup file: `"^""$path`"^""."^""; $skippedCount++; continue; }; } else { if ($path.EndsWith('.OLD')) { Write-Host "^""Skipping backup file: `"^""$path`"^""."^""; $skippedCount++; continue; }; }; $originalFilePath = $path; Write-Host "^""Processing file: `"^""$originalFilePath`"^""."^""; if (-Not (Test-Path $originalFilePath)) { Write-Host "^""Skipping, file `"^""$originalFilePath`"^"" not found."^""; $skippedCount++; exit 0; }; $originalAcl = Get-Acl -Path "^""$originalFilePath"^""; $accessGranted = $false; try { $acl = Get-Acl -Path "^""$originalFilePath"^""; $acl.SetOwner($adminAccount) <# Take Ownership (because file is owned by TrustedInstaller) #>; $acl.AddAccessRule($adminFullControlAccessRule) <# Grant rights to be able to move the file #>; Set-Acl -Path $originalFilePath -AclObject $acl -ErrorAction Stop; $accessGranted = $true; } catch { Write-Warning "^""Failed to grant access to `"^""$originalFilePath`"^"": $($_.Exception.Message)"^""; }; if ($revert -eq $true) { $newFilePath = $originalFilePath.Substring(0, $originalFilePath.Length - 4); } else { $newFilePath = "^""$($originalFilePath).OLD"^""; }; try { Move-Item -LiteralPath "^""$($originalFilePath)"^"" -Destination "^""$newFilePath"^"" -Force -ErrorAction Stop; Write-Host "^""Successfully processed `"^""$originalFilePath`"^""."^""; $renamedCount++; if ($accessGranted) { try { Set-Acl -Path $newFilePath -AclObject $originalAcl -ErrorAction Stop; } catch { Write-Warning "^""Failed to restore access on `"^""$newFilePath`"^"": $($_.Exception.Message)"^""; }; }; } catch { Write-Error "^""Failed to rename `"^""$originalFilePath`"^"" to `"^""$newFilePath`"^"": $($_.Exception.Message)"^""; $failedCount++; if ($accessGranted) { try { Set-Acl -Path $originalFilePath -AclObject $originalAcl -ErrorAction Stop; } catch { Write-Warning "^""Failed to restore access on `"^""$originalFilePath`"^"": $($_.Exception.Message)"^""; }; }; }; }; if (($renamedCount -gt 0) -or ($skippedCount -gt 0)) { Write-Host "^""Successfully processed $renamedCount items and skipped $skippedCount items."^""; }; if ($failedCount -gt 0) { Write-Warning "^""Failed to process $($failedCount) items."^""; }; [Privileges]::RemovePrivilege('SeRestorePrivilege') | Out-Null; [Privileges]::RemovePrivilege('SeTakeOwnershipPrivilege') | Out-Null"
:: Restore files matching pattern: "%SYSTEMDRIVE%\Program Files\WindowsApps\Microsoft.XboxGameCallableUI_*_cw5n1h2txyewy\*" with additional permissions 
PowerShell -ExecutionPolicy Unrestricted -Command "$revert = $true; $pathGlobPattern = "^""%SYSTEMDRIVE%\Program Files\WindowsApps\Microsoft.XboxGameCallableUI_*_cw5n1h2txyewy\*.OLD"^""; $expandedPath = [System.Environment]::ExpandEnvironmentVariables($pathGlobPattern); Write-Host "^""Searching for items matching pattern: `"^""$($expandedPath)`"^""."^""; $renamedCount   = 0; $skippedCount   = 0; $failedCount    = 0; Add-Type -TypeDefinition "^""using System;`r`nusing System.Runtime.InteropServices;`r`npublic class Privileges {`r`n    [DllImport(`"^""advapi32.dll`"^"", ExactSpelling = true, SetLastError = true)]`r`n    internal static extern bool AdjustTokenPrivileges(IntPtr htok, bool disall,`r`n        ref TokPriv1Luid newst, int len, IntPtr prev, IntPtr relen);`r`n    [DllImport(`"^""advapi32.dll`"^"", ExactSpelling = true, SetLastError = true)]`r`n    internal static extern bool OpenProcessToken(IntPtr h, int acc, ref IntPtr phtok);`r`n    [DllImport(`"^""advapi32.dll`"^"", SetLastError = true)]`r`n    internal static extern bool LookupPrivilegeValue(string host, string name, ref long pluid);`r`n    [StructLayout(LayoutKind.Sequential, Pack = 1)]`r`n    internal struct TokPriv1Luid {`r`n        public int Count;`r`n        public long Luid;`r`n        public int Attr;`r`n    }`r`n    internal const int SE_PRIVILEGE_ENABLED = 0x00000002;`r`n    internal const int TOKEN_QUERY = 0x00000008;`r`n    internal const int TOKEN_ADJUST_PRIVILEGES = 0x00000020;`r`n    public static bool AddPrivilege(string privilege) {`r`n        try {`r`n            bool retVal;`r`n            TokPriv1Luid tp;`r`n            IntPtr hproc = GetCurrentProcess();`r`n            IntPtr htok = IntPtr.Zero;`r`n            retVal = OpenProcessToken(hproc, TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, ref htok);`r`n            tp.Count = 1;`r`n            tp.Luid = 0;`r`n            tp.Attr = SE_PRIVILEGE_ENABLED;`r`n            retVal = LookupPrivilegeValue(null, privilege, ref tp.Luid);`r`n            retVal = AdjustTokenPrivileges(htok, false, ref tp, 0, IntPtr.Zero, IntPtr.Zero);`r`n            return retVal;`r`n        } catch (Exception ex) {`r`n            throw new Exception(`"^""Failed to adjust token privileges`"^"", ex);`r`n        }`r`n    }`r`n    public static bool RemovePrivilege(string privilege) {`r`n        try {`r`n            bool retVal;`r`n            TokPriv1Luid tp;`r`n            IntPtr hproc = GetCurrentProcess();`r`n            IntPtr htok = IntPtr.Zero;`r`n            retVal = OpenProcessToken(hproc, TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, ref htok);`r`n            tp.Count = 1;`r`n            tp.Luid = 0;`r`n            tp.Attr = 0;  // This line is changed to revoke the privilege`r`n            retVal = LookupPrivilegeValue(null, privilege, ref tp.Luid);`r`n            retVal = AdjustTokenPrivileges(htok, false, ref tp, 0, IntPtr.Zero, IntPtr.Zero);`r`n            return retVal;`r`n        } catch (Exception ex) {`r`n            throw new Exception(`"^""Failed to adjust token privileges`"^"", ex);`r`n        }`r`n    }`r`n    [DllImport(`"^""kernel32.dll`"^"", CharSet = CharSet.Auto)]`r`n    public static extern IntPtr GetCurrentProcess();`r`n}"^""; [Privileges]::AddPrivilege('SeRestorePrivilege') | Out-Null; [Privileges]::AddPrivilege('SeTakeOwnershipPrivilege') | Out-Null; $adminSid = New-Object System.Security.Principal.SecurityIdentifier 'S-1-5-32-544'; $adminAccount = $adminSid.Translate([System.Security.Principal.NTAccount]); $adminFullControlAccessRule = New-Object System.Security.AccessControl.FileSystemAccessRule( $adminAccount, [System.Security.AccessControl.FileSystemRights]::FullControl, [System.Security.AccessControl.AccessControlType]::Allow ); $foundAbsolutePaths = @(); Write-Host 'Iterating files and directories recursively.'; try { $foundAbsolutePaths += @(; Get-ChildItem -Path $expandedPath -Force -Recurse -ErrorAction Stop | Select-Object -ExpandProperty FullName; ); } catch [System.Management.Automation.ItemNotFoundException] { <# Swallow, do not run `Test-Path` before, it's unreliable for globs requiring extra permissions #>; }; try { $foundAbsolutePaths += @(; Get-Item -Path $expandedPath -ErrorAction Stop | Select-Object -ExpandProperty FullName; ); } catch [System.Management.Automation.ItemNotFoundException] { <# Swallow, do not run `Test-Path` before, it's unreliable for globs requiring extra permissions #>; }; $foundAbsolutePaths = $foundAbsolutePaths | Select-Object -Unique | Sort-Object -Property { $_.Length } -Descending; if (!$foundAbsolutePaths) { Write-Host 'Skipping, no items available.'; exit 0; }; Write-Host "^""Initiating processing of $($foundAbsolutePaths.Count) items from `"^""$expandedPath`"^""."^""; foreach ($path in $foundAbsolutePaths) { if (Test-Path -Path $path -PathType Container) { Write-Host "^""Skipping folder (not its contents): `"^""$path`"^""."^""; $skippedCount++; continue; }; if($revert -eq $true) { if (-not $path.EndsWith('.OLD')) { Write-Host "^""Skipping non-backup file: `"^""$path`"^""."^""; $skippedCount++; continue; }; } else { if ($path.EndsWith('.OLD')) { Write-Host "^""Skipping backup file: `"^""$path`"^""."^""; $skippedCount++; continue; }; }; $originalFilePath = $path; Write-Host "^""Processing file: `"^""$originalFilePath`"^""."^""; if (-Not (Test-Path $originalFilePath)) { Write-Host "^""Skipping, file `"^""$originalFilePath`"^"" not found."^""; $skippedCount++; exit 0; }; $originalAcl = Get-Acl -Path "^""$originalFilePath"^""; $accessGranted = $false; try { $acl = Get-Acl -Path "^""$originalFilePath"^""; $acl.SetOwner($adminAccount) <# Take Ownership (because file is owned by TrustedInstaller) #>; $acl.AddAccessRule($adminFullControlAccessRule) <# Grant rights to be able to move the file #>; Set-Acl -Path $originalFilePath -AclObject $acl -ErrorAction Stop; $accessGranted = $true; } catch { Write-Warning "^""Failed to grant access to `"^""$originalFilePath`"^"": $($_.Exception.Message)"^""; }; if ($revert -eq $true) { $newFilePath = $originalFilePath.Substring(0, $originalFilePath.Length - 4); } else { $newFilePath = "^""$($originalFilePath).OLD"^""; }; try { Move-Item -LiteralPath "^""$($originalFilePath)"^"" -Destination "^""$newFilePath"^"" -Force -ErrorAction Stop; Write-Host "^""Successfully processed `"^""$originalFilePath`"^""."^""; $renamedCount++; if ($accessGranted) { try { Set-Acl -Path $newFilePath -AclObject $originalAcl -ErrorAction Stop; } catch { Write-Warning "^""Failed to restore access on `"^""$newFilePath`"^"": $($_.Exception.Message)"^""; }; }; } catch { Write-Error "^""Failed to rename `"^""$originalFilePath`"^"" to `"^""$newFilePath`"^"": $($_.Exception.Message)"^""; $failedCount++; if ($accessGranted) { try { Set-Acl -Path $originalFilePath -AclObject $originalAcl -ErrorAction Stop; } catch { Write-Warning "^""Failed to restore access on `"^""$originalFilePath`"^"": $($_.Exception.Message)"^""; }; }; }; }; if (($renamedCount -gt 0) -or ($skippedCount -gt 0)) { Write-Host "^""Successfully processed $renamedCount items and skipped $skippedCount items."^""; }; if ($failedCount -gt 0) { Write-Warning "^""Failed to process $($failedCount) items."^""; }; [Privileges]::RemovePrivilege('SeRestorePrivilege') | Out-Null; [Privileges]::RemovePrivilege('SeTakeOwnershipPrivilege') | Out-Null"
:: Remove ability to remove system app 'Microsoft.XboxGameCallableUI' to match operating system defaults
:: Restore "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Appx\AppxAllUserStore\EndOfLife\$CURRENT_USER_SID\Microsoft.XboxGameCallableUI_cw5n1h2txyewy" registry key by deleting it
PowerShell -ExecutionPolicy Unrestricted -Command "$keyPath='HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Appx\AppxAllUserStore\EndOfLife\$CURRENT_USER_SID\Microsoft.XboxGameCallableUI_cw5n1h2txyewy'; $registryHive = $keyPath.Split('\')[0]; $registryPath = "^""$($registryHive):$($keyPath.Substring($registryHive.Length))"^""; $userSid = (New-Object System.Security.Principal.NTAccount($env:USERNAME)).Translate([Security.Principal.SecurityIdentifier]).Value; $registryPath = $registryPath.Replace('$CURRENT_USER_SID', $userSid); Write-Host "^""Removing registry key at `"^""$registryPath`"^""."^""; if (-not (Test-Path -LiteralPath $registryPath)) { Write-Host "^""Skipping, no action needed, registry key `"^""$registryPath`"^"" does not exist."^""; exit 0; }; try { Remove-Item -LiteralPath $registryPath -Force -ErrorAction Stop | Out-Null; Write-Host "^""Successfully removed the registry key at path `"^""$registryPath`"^""."^""; } catch { Write-Error "^""Failed to remove the registry key at path `"^""$registryPath`"^"": $($_.Exception.Message)"^""; }"
:: Reinstall 'Microsoft.XboxGameCallableUI' if it was previously uninstalled
PowerShell -ExecutionPolicy Unrestricted -Command "$packageName='Microsoft.XboxGameCallableUI'; $publisherId='cw5n1h2txyewy'; if (Get-AppxPackage -Name $packageName) { Write-Host "^""Skipping, `"^""$packageName`"^"" is already installed for the current user."^""; exit 0; }; Write-Host "^""Starting the installation process for `"^""$packageName`"^""..."^""; <# Attempt installation using the manifest file #>; Write-Host "^""Checking if `"^""$packageName`"^"" is installed on another user profile..."^""; $packages = @(Get-AppxPackage -AllUsers $packageName); if (!$packages) { Write-Host "^""`"^""$packageName`"^"" is not installed on any other user profiles."^""; } else { foreach ($package in $packages) { Write-Host "^""Found package `"^""$($package.PackageFullName)`"^""."^""; $installationDir = $package.InstallLocation; if ([string]::IsNullOrWhiteSpace($installationDir)) { Write-Warning "^""Installation directory for `"^""$packageName`"^"" is not found or invalid."^""; continue; }; $manifestPath = Join-Path -Path $installationDir -ChildPath 'AppxManifest.xml'; try { if (-Not (Test-Path "^""$manifestPath"^"")) { Write-Host "^""Manifest file not found for `"^""$packageName`"^"" on another user profile: `"^""$manifestPath`"^""."^""; continue; }; } catch { Write-Warning "^""An error occurred while checking for the manifest file: $($_.Exception.Message)"^""; continue; }; Write-Host "^""Manifest file located. Trying to install using the manifest: `"^""$manifestPath`"^""..."^""; try { Add-AppxPackage -DisableDevelopmentMode -Register "^""$manifestPath"^"" -ErrorAction Stop; Write-Host "^""Successfully installed `"^""$packageName`"^"" using its manifest file."^""; exit 0; } catch { Write-Warning "^""Error installing from manifest: $($_.Exception.Message)"^""; }; }; }; <# Attempt installation using the package family name #>; $packageFamilyName = "^""$($packageName)_$($publisherId)"^""; Write-Host "^""Trying to install `"^""$packageName`"^"" using its package family name: `"^""$packageFamilyName`"^"" from system installation..."^""; try { Add-AppxPackage -RegisterByFamilyName -MainPackage $packageFamilyName -ErrorAction Stop; Write-Host "^""Successfully installed `"^""$packageName`"^"" using its package family name."^""; exit 0; } catch { Write-Warning "^""Error installing using package family name: $($_.Exception.Message)"^""; }; throw "^""Unable to reinstall the requested package ($packageName). "^"" + "^""It appears to no longer be included in this version of Windows. "^"" + "^""You may search for it or an alternative in the Microsoft Store or "^"" + "^""consider using an earlier version of Windows where this package was originally provided."^"""
:: Remove 'Microsoft.XboxGameCallableUI' from deprovisioned list to allow reinstall during updates.
:: Restore "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Appx\AppxAllUserStore\Deprovisioned\Microsoft.XboxGameCallableUI_cw5n1h2txyewy" registry key by deleting it
PowerShell -ExecutionPolicy Unrestricted -Command "$keyPath='HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Appx\AppxAllUserStore\Deprovisioned\Microsoft.XboxGameCallableUI_cw5n1h2txyewy'; $registryHive = $keyPath.Split('\')[0]; $registryPath = "^""$($registryHive):$($keyPath.Substring($registryHive.Length))"^""; Write-Host "^""Removing registry key at `"^""$registryPath`"^""."^""; if (-not (Test-Path -LiteralPath $registryPath)) { Write-Host "^""Skipping, no action needed, registry key `"^""$registryPath`"^"" does not exist."^""; exit 0; }; try { Remove-Item -LiteralPath $registryPath -Force -ErrorAction Stop | Out-Null; Write-Host "^""Successfully removed the registry key at path `"^""$registryPath`"^""."^""; } catch { Write-Error "^""Failed to remove the registry key at path `"^""$registryPath`"^"": $($_.Exception.Message)"^""; }"
:: Restore files matching pattern: "%LOCALAPPDATA%\Packages\Microsoft.XboxGameCallableUI_cw5n1h2txyewy\*"  
PowerShell -ExecutionPolicy Unrestricted -Command "$revert = $true; $pathGlobPattern = "^""%LOCALAPPDATA%\Packages\Microsoft.XboxGameCallableUI_cw5n1h2txyewy\*.OLD"^""; $expandedPath = [System.Environment]::ExpandEnvironmentVariables($pathGlobPattern); Write-Host "^""Searching for items matching pattern: `"^""$($expandedPath)`"^""."^""; $renamedCount   = 0; $skippedCount   = 0; $failedCount    = 0; $foundAbsolutePaths = @(); Write-Host 'Iterating files and directories recursively.'; try { $foundAbsolutePaths += @(; Get-ChildItem -Path $expandedPath -Force -Recurse -ErrorAction Stop | Select-Object -ExpandProperty FullName; ); } catch [System.Management.Automation.ItemNotFoundException] { <# Swallow, do not run `Test-Path` before, it's unreliable for globs requiring extra permissions #>; }; try { $foundAbsolutePaths += @(; Get-Item -Path $expandedPath -ErrorAction Stop | Select-Object -ExpandProperty FullName; ); } catch [System.Management.Automation.ItemNotFoundException] { <# Swallow, do not run `Test-Path` before, it's unreliable for globs requiring extra permissions #>; }; $foundAbsolutePaths = $foundAbsolutePaths | Select-Object -Unique | Sort-Object -Property { $_.Length } -Descending; if (!$foundAbsolutePaths) { Write-Host 'Skipping, no items available.'; exit 0; }; Write-Host "^""Initiating processing of $($foundAbsolutePaths.Count) items from `"^""$expandedPath`"^""."^""; foreach ($path in $foundAbsolutePaths) { if (Test-Path -Path $path -PathType Container) { Write-Host "^""Skipping folder (not its contents): `"^""$path`"^""."^""; $skippedCount++; continue; }; if($revert -eq $true) { if (-not $path.EndsWith('.OLD')) { Write-Host "^""Skipping non-backup file: `"^""$path`"^""."^""; $skippedCount++; continue; }; } else { if ($path.EndsWith('.OLD')) { Write-Host "^""Skipping backup file: `"^""$path`"^""."^""; $skippedCount++; continue; }; }; $originalFilePath = $path; Write-Host "^""Processing file: `"^""$originalFilePath`"^""."^""; if (-Not (Test-Path $originalFilePath)) { Write-Host "^""Skipping, file `"^""$originalFilePath`"^"" not found."^""; $skippedCount++; exit 0; }; if ($revert -eq $true) { $newFilePath = $originalFilePath.Substring(0, $originalFilePath.Length - 4); } else { $newFilePath = "^""$($originalFilePath).OLD"^""; }; try { Move-Item -LiteralPath "^""$($originalFilePath)"^"" -Destination "^""$newFilePath"^"" -Force -ErrorAction Stop; Write-Host "^""Successfully processed `"^""$originalFilePath`"^""."^""; $renamedCount++; } catch { Write-Error "^""Failed to rename `"^""$originalFilePath`"^"" to `"^""$newFilePath`"^"": $($_.Exception.Message)"^""; $failedCount++; }; }; if (($renamedCount -gt 0) -or ($skippedCount -gt 0)) { Write-Host "^""Successfully processed $renamedCount items and skipped $skippedCount items."^""; }; if ($failedCount -gt 0) { Write-Warning "^""Failed to process $($failedCount) items."^""; }"
:: Restore files matching pattern: "%PROGRAMDATA%\Microsoft\Windows\AppRepository\Packages\Microsoft.XboxGameCallableUI_*_cw5n1h2txyewy\*" with additional permissions 
PowerShell -ExecutionPolicy Unrestricted -Command "$revert = $true; $pathGlobPattern = "^""%PROGRAMDATA%\Microsoft\Windows\AppRepository\Packages\Microsoft.XboxGameCallableUI_*_cw5n1h2txyewy\*.OLD"^""; $expandedPath = [System.Environment]::ExpandEnvironmentVariables($pathGlobPattern); Write-Host "^""Searching for items matching pattern: `"^""$($expandedPath)`"^""."^""; $renamedCount   = 0; $skippedCount   = 0; $failedCount    = 0; Add-Type -TypeDefinition "^""using System;`r`nusing System.Runtime.InteropServices;`r`npublic class Privileges {`r`n    [DllImport(`"^""advapi32.dll`"^"", ExactSpelling = true, SetLastError = true)]`r`n    internal static extern bool AdjustTokenPrivileges(IntPtr htok, bool disall,`r`n        ref TokPriv1Luid newst, int len, IntPtr prev, IntPtr relen);`r`n    [DllImport(`"^""advapi32.dll`"^"", ExactSpelling = true, SetLastError = true)]`r`n    internal static extern bool OpenProcessToken(IntPtr h, int acc, ref IntPtr phtok);`r`n    [DllImport(`"^""advapi32.dll`"^"", SetLastError = true)]`r`n    internal static extern bool LookupPrivilegeValue(string host, string name, ref long pluid);`r`n    [StructLayout(LayoutKind.Sequential, Pack = 1)]`r`n    internal struct TokPriv1Luid {`r`n        public int Count;`r`n        public long Luid;`r`n        public int Attr;`r`n    }`r`n    internal const int SE_PRIVILEGE_ENABLED = 0x00000002;`r`n    internal const int TOKEN_QUERY = 0x00000008;`r`n    internal const int TOKEN_ADJUST_PRIVILEGES = 0x00000020;`r`n    public static bool AddPrivilege(string privilege) {`r`n        try {`r`n            bool retVal;`r`n            TokPriv1Luid tp;`r`n            IntPtr hproc = GetCurrentProcess();`r`n            IntPtr htok = IntPtr.Zero;`r`n            retVal = OpenProcessToken(hproc, TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, ref htok);`r`n            tp.Count = 1;`r`n            tp.Luid = 0;`r`n            tp.Attr = SE_PRIVILEGE_ENABLED;`r`n            retVal = LookupPrivilegeValue(null, privilege, ref tp.Luid);`r`n            retVal = AdjustTokenPrivileges(htok, false, ref tp, 0, IntPtr.Zero, IntPtr.Zero);`r`n            return retVal;`r`n        } catch (Exception ex) {`r`n            throw new Exception(`"^""Failed to adjust token privileges`"^"", ex);`r`n        }`r`n    }`r`n    public static bool RemovePrivilege(string privilege) {`r`n        try {`r`n            bool retVal;`r`n            TokPriv1Luid tp;`r`n            IntPtr hproc = GetCurrentProcess();`r`n            IntPtr htok = IntPtr.Zero;`r`n            retVal = OpenProcessToken(hproc, TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, ref htok);`r`n            tp.Count = 1;`r`n            tp.Luid = 0;`r`n            tp.Attr = 0;  // This line is changed to revoke the privilege`r`n            retVal = LookupPrivilegeValue(null, privilege, ref tp.Luid);`r`n            retVal = AdjustTokenPrivileges(htok, false, ref tp, 0, IntPtr.Zero, IntPtr.Zero);`r`n            return retVal;`r`n        } catch (Exception ex) {`r`n            throw new Exception(`"^""Failed to adjust token privileges`"^"", ex);`r`n        }`r`n    }`r`n    [DllImport(`"^""kernel32.dll`"^"", CharSet = CharSet.Auto)]`r`n    public static extern IntPtr GetCurrentProcess();`r`n}"^""; [Privileges]::AddPrivilege('SeRestorePrivilege') | Out-Null; [Privileges]::AddPrivilege('SeTakeOwnershipPrivilege') | Out-Null; $adminSid = New-Object System.Security.Principal.SecurityIdentifier 'S-1-5-32-544'; $adminAccount = $adminSid.Translate([System.Security.Principal.NTAccount]); $adminFullControlAccessRule = New-Object System.Security.AccessControl.FileSystemAccessRule( $adminAccount, [System.Security.AccessControl.FileSystemRights]::FullControl, [System.Security.AccessControl.AccessControlType]::Allow ); $foundAbsolutePaths = @(); Write-Host 'Iterating files and directories recursively.'; try { $foundAbsolutePaths += @(; Get-ChildItem -Path $expandedPath -Force -Recurse -ErrorAction Stop | Select-Object -ExpandProperty FullName; ); } catch [System.Management.Automation.ItemNotFoundException] { <# Swallow, do not run `Test-Path` before, it's unreliable for globs requiring extra permissions #>; }; try { $foundAbsolutePaths += @(; Get-Item -Path $expandedPath -ErrorAction Stop | Select-Object -ExpandProperty FullName; ); } catch [System.Management.Automation.ItemNotFoundException] { <# Swallow, do not run `Test-Path` before, it's unreliable for globs requiring extra permissions #>; }; $foundAbsolutePaths = $foundAbsolutePaths | Select-Object -Unique | Sort-Object -Property { $_.Length } -Descending; if (!$foundAbsolutePaths) { Write-Host 'Skipping, no items available.'; exit 0; }; Write-Host "^""Initiating processing of $($foundAbsolutePaths.Count) items from `"^""$expandedPath`"^""."^""; foreach ($path in $foundAbsolutePaths) { if (Test-Path -Path $path -PathType Container) { Write-Host "^""Skipping folder (not its contents): `"^""$path`"^""."^""; $skippedCount++; continue; }; if($revert -eq $true) { if (-not $path.EndsWith('.OLD')) { Write-Host "^""Skipping non-backup file: `"^""$path`"^""."^""; $skippedCount++; continue; }; } else { if ($path.EndsWith('.OLD')) { Write-Host "^""Skipping backup file: `"^""$path`"^""."^""; $skippedCount++; continue; }; }; $originalFilePath = $path; Write-Host "^""Processing file: `"^""$originalFilePath`"^""."^""; if (-Not (Test-Path $originalFilePath)) { Write-Host "^""Skipping, file `"^""$originalFilePath`"^"" not found."^""; $skippedCount++; exit 0; }; $originalAcl = Get-Acl -Path "^""$originalFilePath"^""; $accessGranted = $false; try { $acl = Get-Acl -Path "^""$originalFilePath"^""; $acl.SetOwner($adminAccount) <# Take Ownership (because file is owned by TrustedInstaller) #>; $acl.AddAccessRule($adminFullControlAccessRule) <# Grant rights to be able to move the file #>; Set-Acl -Path $originalFilePath -AclObject $acl -ErrorAction Stop; $accessGranted = $true; } catch { Write-Warning "^""Failed to grant access to `"^""$originalFilePath`"^"": $($_.Exception.Message)"^""; }; if ($revert -eq $true) { $newFilePath = $originalFilePath.Substring(0, $originalFilePath.Length - 4); } else { $newFilePath = "^""$($originalFilePath).OLD"^""; }; try { Move-Item -LiteralPath "^""$($originalFilePath)"^"" -Destination "^""$newFilePath"^"" -Force -ErrorAction Stop; Write-Host "^""Successfully processed `"^""$originalFilePath`"^""."^""; $renamedCount++; if ($accessGranted) { try { Set-Acl -Path $newFilePath -AclObject $originalAcl -ErrorAction Stop; } catch { Write-Warning "^""Failed to restore access on `"^""$newFilePath`"^"": $($_.Exception.Message)"^""; }; }; } catch { Write-Error "^""Failed to rename `"^""$originalFilePath`"^"" to `"^""$newFilePath`"^"": $($_.Exception.Message)"^""; $failedCount++; if ($accessGranted) { try { Set-Acl -Path $originalFilePath -AclObject $originalAcl -ErrorAction Stop; } catch { Write-Warning "^""Failed to restore access on `"^""$originalFilePath`"^"": $($_.Exception.Message)"^""; }; }; }; }; if (($renamedCount -gt 0) -or ($skippedCount -gt 0)) { Write-Host "^""Successfully processed $renamedCount items and skipped $skippedCount items."^""; }; if ($failedCount -gt 0) { Write-Warning "^""Failed to process $($failedCount) items."^""; }; [Privileges]::RemovePrivilege('SeRestorePrivilege') | Out-Null; [Privileges]::RemovePrivilege('SeTakeOwnershipPrivilege') | Out-Null"
:: ----------------------------------------------------------


:: Pause the script to view the final state
pause
:: Restore previous environment settings
endlocal
:: Exit the script successfully
exit /b 0